## Day 14: Classes

### Tasks/Activities:

#### Activity 1: Class Definition
- **Task 1:** Define a class `Person` with properties `name` and `age`, and a method to return a greeting message. Create an instance of the class and log the greeting message.
- **Task 2:** Add a method to the `Person` class that updates the `age` property and logs the updated age.

#### Activity 2: Class Inheritance
- **Task 3:** Define a class `Student` that extends the `Person` class. Add a property `studentId` and a method to return the student ID. Create an instance of the `Student` class and log the student ID.
- **Task 4:** Override the greeting method in the `Student` class to include the student ID in the message. Log the overridden greeting message.

#### Activity 3: Static Methods and Properties
- **Task 5:** Add a static method to the `Person` class that returns a generic greeting message. Call this static method without creating an instance of the class and log the message.
- **Task 6:** Add a static property to the `Student` class to keep track of the number of students created. Increment this property in the constructor and log the total number of students.

#### Activity 4: Getters and Setters
- **Task 7:** Add a getter method to the `Person` class to return the full name (assume a `firstName` and `lastName` property). Create an instance and log the full name using the getter.
- **Task 8:** Add a setter method to the `Person` class to update the name properties (`firstName` and `lastName`). Update the name using the setter and log the updated full name.

#### Activity 5: Private Fields (Optional)
- **Task 9:** Define a class `Account` with private fields for `balance` and a method to deposit and withdraw money. Ensure that the balance can only be updated through these methods.
- **Task 10:** Create an instance of the `Account` class and test the deposit and withdraw methods, logging the balance after each operation.

### Feature Request:

1. **Basic Class Script:** Write a script that defines a `Person` class with properties and methods, creates instances, and logs messages.
2. **Class Inheritance Script:** Create a script that defines a `Student` class extending `Person`, overrides methods, and logs the results.
3. **Static Methods and Properties Script:** Write a script that demonstrates static methods and properties in classes.
4. **Getters and Setters Script:** Create a script that uses getters and setters in a class.
5. **Private Fields Script:** Write a script that defines a class with private fields and methods to manipulate these fields (optional).

### Achievement:

By the end of these activities, students will:
- Define and use classes with properties and methods.
- Implement inheritance to extend classes.
- Utilize static methods and properties.
- Apply getters and setters for encapsulation.
- Understand and use private fields in classes (optional).
